package com.vaadin.copilot;

import java.io.File;

import com.vaadin.copilot.exception.KotlinNotSupportedException;

public class KotlinUtil {
    private KotlinUtil() {
    }

    /**
     * Checks file extension is kotlin extensions .e.g kt, kts and throws
     * {@link KotlinNotSupportedException} when file has one of the extensions
     *
     * @param file
     *            File to check
     */
    public static void throwIfKotlin(File file) {
        if (file == null) {
            return;
        }
        if (isKotlin(file)) {
            throw new KotlinNotSupportedException();
        }
    }

    /**
     * Checks file extension is kotlin extensions .e.g kt, kts
     *
     * @param file
     *            File to check
     * @return true if kotlin file, false otherwise.
     */
    public static boolean isKotlin(File file) {
        return Util.hasExtension(file.getName(), "kt", "kts");
    }

}
