package com.vaadin.copilot.testbenchgenerator;

import java.util.Arrays;

/**
 * Represents the type of item of a scenario item. Based on the type, the given
 * scenario is cast to relevant class.
 */
public enum TestBenchScenarioItemType {
    assertion, pageChangeEvent, targetEvent;

    /**
     * Finds the first matching item based on the string match. Ignores the case
     * sensitivity.
     * 
     * @param str
     *            string that will be searched in the values
     * @return Enum value, or null if not found.
     */
    public static TestBenchScenarioItemType fromString(String str) {
        return Arrays.stream(TestBenchScenarioItemType.values())
                .filter(scenario -> scenario.name().equalsIgnoreCase(str)).findFirst().orElse(null);
    }
}
