package com.vaadin.copilot.testbenchgenerator;

/**
 * Represents a scenario item that targets a specific UI element within a
 * TestBench test scenario.
 *
 * <p>
 * This class extends {@link TestBenchScenarioItem} and contains metadata and
 * selection strategies for identifying a particular element in the DOM. It is
 * typically used during the generation or execution of automated UI tests,
 * where identifying the right element and selector is crucial.
 * </p>
 *
 * <p>
 * The following key attributes define the targeted element:
 * </p>
 * <ul>
 * <li>{@code targetElementIdentifier} - A unique identifier string used to
 * generate a variable name for the element.</li>
 * <li>{@code targetElementLocalName} - The local (tag) name of the targeted DOM
 * element, such as {@code div}, {@code vaadin-button}, etc.</li>
 * <li>{@code classInfo} - Contains reflective or structural information about
 * the Java class representing the target element.</li>
 * <li>{@code possibleSelectors} - A set of possible CSS or DOM-based selectors
 * that can be used to locate the target element during test execution.</li>
 * </ul>
 *
 */
public class TargetScenarioItem extends TestBenchScenarioItem {
    // identifier is used to generate variable name.
    private String targetElementIdentifier;
    private String targetElementLocalName;
    private TestBenchElementClassInfo classInfo;
    private PossibleSelectors possibleSelectors;

    public String getTargetElementLocalName() {
        return targetElementLocalName;
    }

    public void setTargetElementLocalName(String targetElementLocalName) {
        this.targetElementLocalName = targetElementLocalName;
    }

    public TestBenchElementClassInfo getClassInfo() {
        return classInfo;
    }

    public void setClassInfo(TestBenchElementClassInfo classInfo) {
        this.classInfo = classInfo;
    }

    public PossibleSelectors getPossibleSelectors() {
        return possibleSelectors;
    }

    public void setPossibleSelectors(PossibleSelectors possibleSelectors) {
        this.possibleSelectors = possibleSelectors;
    }

    public String getTargetElementIdentifier() {
        return targetElementIdentifier;
    }

    public void setTargetElementIdentifier(String targetElementIdentifier) {
        this.targetElementIdentifier = targetElementIdentifier;
    }
}
