package com.vaadin.copilot.plugins.docs;

import java.util.Objects;

import com.vaadin.copilot.plugins.themeeditor.messages.BaseRequest;

public class DocsRequest extends BaseRequest {
    private boolean flowComponent;
    private boolean reactComponent;
    private boolean customComponent;
    private String tag;

    public boolean isFlowComponent() {
        return flowComponent;
    }

    public void setFlowComponent(boolean flowComponent) {
        this.flowComponent = flowComponent;
    }

    public boolean isReactComponent() {
        return reactComponent;
    }

    public void setReactComponent(boolean reactComponent) {
        this.reactComponent = reactComponent;
    }

    public boolean isCustomComponent() {
        return customComponent;
    }

    public void setCustomComponent(boolean customComponent) {
        this.customComponent = customComponent;
    }

    public String getTag() {
        return tag;
    }

    public void setTag(String tag) {
        this.tag = tag;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o)
            return true;
        if (o == null || getClass() != o.getClass())
            return false;
        DocsRequest that = (DocsRequest) o;
        return flowComponent == that.flowComponent && reactComponent == that.reactComponent
                && customComponent == that.customComponent && Objects.equals(tag, that.tag);
    }

    @Override
    public int hashCode() {
        return Objects.hash(flowComponent, reactComponent, customComponent, tag);
    }
}
