package com.vaadin.copilot.plugins.devsetup;

import com.vaadin.base.devserver.DevToolsInterface;
import com.vaadin.copilot.CopilotCommand;
import com.vaadin.copilot.ide.CopilotIDEPlugin;
import com.vaadin.copilot.ide.IDEHeartbeatScheduler;
import com.vaadin.flow.internal.JacksonUtils;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import tools.jackson.databind.DeserializationFeature;
import tools.jackson.databind.JsonNode;
import tools.jackson.databind.json.JsonMapper;

/**
 * Handler for development environment setup.
 */
public class DevSetupHandler extends CopilotCommand {
    private final CopilotIDEPlugin idePlugin;
    private final JsonMapper objectMapper;

    public DevSetupHandler(CopilotIDEPlugin idePlugin) {
        this.idePlugin = idePlugin;
        this.objectMapper = JsonMapper.builder().configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false)
                .build();
    }

    @Override
    public boolean handleMessage(String command, JsonNode data, DevToolsInterface devToolsInterface) {
        if ("get-dev-setup-info".equals(command)) {
            IDEHeartbeatScheduler.getInstance().startIfNotStarted();
            var responseData = JacksonUtils.createObjectNode();

            try {
                DevSetupInfo devSetupInfo = new DevSetupInfo(idePlugin.getPluginInfo());
                responseData.put("content", objectMapper.writeValueAsString(devSetupInfo));
                devToolsInterface.send("copilot-get-dev-setup-info-response", responseData);
            } catch (Exception e) {
                getLogger().error(e.getMessage(), e);
            }

            return true;
        }
        return false;
    }

    protected Logger getLogger() {
        return LoggerFactory.getLogger(getClass());
    }
}
