package com.vaadin.copilot.customcomponent;

/**
 * Contains information for custom components that are defined outside the
 * project. e.g. addon, external maven libraries etc...
 *
 * @param componentClass
 *            Class instance of custom component
 */
public record CustomComponentExternal(Class<?> componentClass) implements CustomComponent {
    @Override
    public Type getType() {
        return Type.EXTERNAL;
    }

    @Override
    public boolean litTemplate() {
        return false;
    }
}
