package com.vaadin.copilot;

import java.io.IOException;
import java.nio.charset.StandardCharsets;

import com.vaadin.base.devserver.DevToolsInterface;
import com.vaadin.flow.internal.JacksonUtils;

import org.apache.commons.io.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import tools.jackson.databind.JsonNode;
import tools.jackson.databind.node.ObjectNode;

public class MachineConfigurationHandler extends CopilotCommand {
    @Override
    public boolean handleMessage(String command, JsonNode data, DevToolsInterface devToolsInterface) {
        if (command.equals("get-machine-configuration")) {
            ObjectNode response = JacksonUtils.createObjectNode();
            response.set("conf", MachineConfiguration.get().getJson());
            devToolsInterface.send("copilot-machine-configuration", response);
            return true;
        } else if (command.equals("set-machine-configuration")) {
            try {
                String json = data.get("conf").asString();
                FileUtils.write(MachineConfiguration.getFile(), json + "\n", StandardCharsets.UTF_8);
                getLogger().debug("Writing configuration: {}", json);
            } catch (IOException e) {
                getLogger().error("Failed to write machine configuration", e);
            }
            return true;
        }
        return false;
    }

    private static Logger getLogger() {
        return LoggerFactory.getLogger(MachineConfigurationHandler.class);
    }

}
