package com.vaadin.copilot;

import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentEvent;
import com.vaadin.flow.component.ComponentEventBus;
import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.component.HtmlComponent;
import com.vaadin.flow.shared.Registration;

public class HotswapEventBus extends ComponentEventBus {

    private static final Component FAKE_COMPONENT = new HtmlComponent("div");
    private static final HotswapEventBus instance = new HotswapEventBus();

    public static class CopilotHotswapEvent extends ComponentEvent<Component> {

        private final Class<?> hotwappedClass;
        private final boolean redefined;

        /**
         * Creates a new event.
         */
        public CopilotHotswapEvent(Class<?> hotwappedClass, boolean redefined) {
            super(FAKE_COMPONENT, false);
            this.hotwappedClass = hotwappedClass;
            this.redefined = redefined;
        }

        /**
         * Gets the hotswapped class.
         * 
         * @return the hotswapped class
         */
        public Class<?> getHotswappedClass() {
            return hotwappedClass;
        }

        /**
         * Returns whether the class was redefined.
         * 
         * @return true if the class was redefined, false otherwise
         */
        public boolean isRedefined() {
            return redefined;
        }

    }

    public static HotswapEventBus getInstance() {
        return instance;
    }

    /**
     * Creates an event bus.
     */
    public HotswapEventBus() {
        super(FAKE_COMPONENT);
    }

    /**
     * Adds a listener to the event bus.
     * 
     * @param listener
     *            the listener to add
     * @return a registration that can be used to remove the listener
     */
    public Registration addListener(ComponentEventListener<CopilotHotswapEvent> listener) {
        return addListener(CopilotHotswapEvent.class, listener);
    }

}
