package com.vaadin.copilot;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.function.Consumer;

import com.vaadin.flow.server.frontend.installer.DownloadException;

/** A class for downloading the Hotswap Agent JAR file. */
public final class HotswapAgentDownloader {

    /**
     * Downloads the Hotswap Agent JAR file into the given target file.
     *
     * @param target
     *            the target file
     * @param statusUpdater
     *            a consumer that will be called with status updates
     */
    public void downloadHotswapAgent(File target, Consumer<String> statusUpdater)
            throws MalformedURLException, DownloadException, URISyntaxException {
        URL url = new URL(
                "https://github.com/HotswapProjects/HotswapAgent/releases/download/RELEASE-2.0.1/hotswap-agent-2.0.1.jar");

        statusUpdater.accept("Downloading Hotswap Agent from " + url);
        Downloader.downloadFile(url, target, (bytesTransferred, totalBytes, progress) -> statusUpdater
                .accept(HotswapDownloadHandler.PROGRESS_PREFIX + progress));
        statusUpdater.accept("Downloaded Hotswap Agent into " + target.getAbsolutePath());
    }
}
