package com.vaadin.copilot.testbenchgenerator.assertion;

import com.vaadin.copilot.testbenchgenerator.TestBenchScenarioItem;

/**
 * Assertion scenario item represents Assertion conditions in TestBench test.
 * Expected conditions are represented with this base class.
 */
public class AssertionScenarioItem extends TestBenchScenarioItem {
    private AssertionType assertionType;

    public AssertionType getAssertionType() {
        return assertionType;
    }

    public void setAssertionType(AssertionType assertionType) {
        this.assertionType = assertionType;
    }

    // TODO generic type should extend from AssertScenario after TargetAssertion and
    // AssertionScenario unified
    public static Class<? extends TestBenchScenarioItem> getScenarioClass(String assertionTypeStr) {
        AssertionType type = AssertionType.fromString(assertionTypeStr);
        if (type == null) {
            throw new IllegalArgumentException("Unable to parse assertion type " + assertionTypeStr);
        }
        if (type == AssertionType.textEquals) {
            return TextEqualsAssertionItem.class;
        } else if (type == AssertionType.presence) {
            return TargetAssertionScenarioItem.class;
        } else if (type == AssertionType.noJsError) {
            return AssertionScenarioItem.class;
        } else if (type == AssertionType.pageTitleEquals) {
            return PageTitleEqualsAssertion.class;
        }
        throw new IllegalArgumentException("Unknown assertion type " + assertionTypeStr);
    }
}
