package com.vaadin.copilot.testbenchgenerator;

import java.io.File;
import java.nio.file.Path;

import com.vaadin.base.devserver.DevToolsInterface;
import com.vaadin.copilot.CopilotCommand;
import com.vaadin.copilot.ErrorHandler;
import com.vaadin.copilot.ProjectFileManager;
import com.vaadin.copilot.exception.report.ExceptionReportCreator;
import com.vaadin.flow.internal.JacksonUtils;

import tools.jackson.databind.JsonNode;
import tools.jackson.databind.node.ObjectNode;

/**
 * Handler that handles commands to generate recorded test bench tests
 */
public class TestBenchRecordHandler extends CopilotCommand {
    private static final String REQ_ID = "reqId";

    @Override
    public boolean handleMessage(String command, JsonNode data, DevToolsInterface devToolsInterface) {
        if (command.equals("create-test-bench-tests")) {
            ObjectNode response = JacksonUtils.createObjectNode();
            response.put(REQ_ID, data.get(REQ_ID).asString());

            TestBenchScenario scenario = TestBenchScenario.from(data.get("scenario"));
            TestBenchJavaTestGenerator testBenchJavaTestGenerator = new TestBenchJavaTestGenerator(scenario);
            try {
                TestBenchGenerateResult result = testBenchJavaTestGenerator.generate();
                response.set("result", JacksonUtils.writeValue(result));
            } catch (Throwable e) {
                ErrorHandler.sendErrorResponse(devToolsInterface, command, response, "Unable to generate tests", e,
                        new ExceptionReportCreator());
                response.put("error", true);
                response.put("errorMessage", e.getMessage());
            }
            devToolsInterface.send(command + "-response", response);
            return true;
        } else if (command.equals("get-test-bench-qualified-class-name")) {
            ObjectNode response = JacksonUtils.createObjectNode();
            response.put(REQ_ID, data.get(REQ_ID).asString());
            response.put("qualifiedClassName", getTestBenchClassName());

            devToolsInterface.send(command + "-response", response);
            return true;
        }
        return false;
    }

    private String getTestBenchClassName() {

        File javaSourceFolder = ProjectFileManager.get().getJavaSourceFolder();
        Path srcFolder = javaSourceFolder.toPath().getParent().getParent();

        Path testFolder = Path.of(srcFolder.toAbsolutePath().toString(), "/test/java");
        Path testFilePath = Path.of(testFolder.toAbsolutePath().toString(), "/testbench/TestBenchIT.java");
        return testFolder.relativize(testFilePath).toString();
    }
}
