package com.vaadin.copilot.plugins.themeeditor.handlers;

import java.util.ArrayList;
import java.util.List;

import com.vaadin.copilot.plugins.themeeditor.ThemeEditorCommand;
import com.vaadin.copilot.plugins.themeeditor.messages.BaseResponse;
import com.vaadin.copilot.plugins.themeeditor.messages.RulesRequest;
import com.vaadin.copilot.plugins.themeeditor.utils.CssRule;
import com.vaadin.copilot.plugins.themeeditor.utils.HasThemeModifier;
import com.vaadin.copilot.plugins.themeeditor.utils.MessageHandler;
import com.vaadin.flow.internal.JacksonUtils;

import tools.jackson.databind.JsonNode;

public class RulesHandler implements MessageHandler {

    private final HasThemeModifier hasThemeModifier;

    public RulesHandler(HasThemeModifier hasThemeModifier) {
        this.hasThemeModifier = hasThemeModifier;
    }

    @Override
    public BaseResponse handle(JsonNode data) {
        RulesRequest request = JacksonUtils.readToObject(data, RulesRequest.class);

        // needs to be final for ExecuteAndUndo lambdas
        final List<CssRule> rules = new ArrayList<>(request.getRules());
        hasThemeModifier.getThemeModifier().setThemeProperties(rules);
        return BaseResponse.ok();
    }

    @Override
    public String getCommandName() {
        return ThemeEditorCommand.RULES.getValue();
    }
}
