package com.vaadin.copilot;

import java.io.File;
import java.util.Optional;
import java.util.Set;

import com.vaadin.base.devserver.DebugWindowConnection;
import com.vaadin.flow.hotswap.HotswapCompleteEvent;
import com.vaadin.flow.hotswap.VaadinHotswapper;
import com.vaadin.flow.internal.BrowserLiveReload;
import com.vaadin.flow.internal.BrowserLiveReloadAccessor;
import com.vaadin.flow.internal.JacksonUtils;
import com.vaadin.flow.router.Route;
import com.vaadin.flow.router.internal.RouteUtil;
import com.vaadin.flow.server.VaadinService;

import tools.jackson.databind.node.ArrayNode;
import tools.jackson.databind.node.ObjectNode;

public class HotswapListener implements VaadinHotswapper {

    @Override
    public void onHotswapComplete(HotswapCompleteEvent event) {
        VaadinService service = event.getService();
        BrowserLiveReload liveReload = BrowserLiveReloadAccessor.getLiveReloadFromService(service).orElse(null);

        if (liveReload != null && anyClassInProject(event.getClasses())) {
            ObjectNode msg = JacksonUtils.createObjectNode();
            msg.put("command", Copilot.PREFIX + "java-after-update");
            ObjectNode data = JacksonUtils.createObjectNode();
            ArrayNode classes = JacksonUtils.createArray();
            data.set("classes", classes);
            for (Class<?> cls : event.getClasses()) {
                ObjectNode classInfo = JacksonUtils.createObjectNode();
                getRoutePath(service, cls).ifPresent(routePath -> classInfo.put("routePath", routePath));
                classInfo.put("class", cls.getName());
                classInfo.put("redefined", event.isRedefined());
                classes.add(classInfo);
                HotswapEventBus.getInstance()
                        .fireEvent(new HotswapEventBus.CopilotHotswapEvent(cls, event.isRedefined()));
            }
            msg.set("data", data);
            ((DebugWindowConnection) liveReload).broadcast(msg);
        }
    }

    private boolean anyClassInProject(Set<Class<?>> classSet) {
        ProjectFileManager projectFileManager = ProjectFileManager.get();
        if (projectFileManager == null) {
            return true;
        }
        return classSet.stream().anyMatch(aClass -> {
            File fileForClass = projectFileManager.getFileForClass(aClass);
            return fileForClass != null && fileForClass.exists()
                    && projectFileManager.isFileInsideProject(fileForClass);
        });
    }

    private Optional<String> getRoutePath(VaadinService service, Class<?> maybeRouteClass) {
        if (maybeRouteClass.getAnnotation(Route.class) != null) {
            return Optional.ofNullable(RouteUtil.getRoutePath(service.getContext(), maybeRouteClass));
        }
        return Optional.empty();
    }
}
