package com.vaadin.copilot.feedback;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;

import com.vaadin.base.devserver.DevToolsInterface;
import com.vaadin.base.devserver.stats.ProjectHelpers;
import com.vaadin.copilot.CopilotCommand;
import com.vaadin.pro.licensechecker.LocalProKey;
import com.vaadin.pro.licensechecker.ProKey;

import com.fasterxml.jackson.databind.JsonNode;

public class FeedbackHandler extends CopilotCommand {

    private final List<String> expectedData = List.of("type", "topic", "email", "description", "versions");

    private final FeedbackClient client;

    public FeedbackHandler() {
        this.client = new FeedbackClient();
    }

    @Override
    public boolean handleMessage(String command, JsonNode data, DevToolsInterface devToolsInterface) {

        if (command.equals("feedback")) {
            Map<String, String> map = new HashMap<>();
            expectedData.forEach(key -> map.put(key, data.hasNonNull(key) ? data.get(key).asText() : null));
            String userKey = ProjectHelpers.getUserKey();
            String proKey = Optional.ofNullable(LocalProKey.get()).map(ProKey::toJson).orElse(null);
            client.sendFeedback(userKey, proKey, map);
            return true;
        }

        return false;
    }
}
