package com.vaadin.copilot.exception.report;

import java.util.ArrayList;
import java.util.List;

/**
 * Represents a report for tracking exceptions within an application.
 * <p>
 * <p>
 * This class stores a collection of relevant data pairs, component nodes, and
 * detailed exception items associated with an exception. Each report is
 * uniquely identified by a generated UUID.
 * <p>
 * Some items are set in client.
 * </p>
 */
public class ExceptionReport {
    private String title;
    private List<ExceptionReportRelevantPairData> relevantPairs = new ArrayList<>();
    private List<ExceptionReportRelevantComponentNode> nodes = new ArrayList<>();
    private List<ExceptionReportItem> items = new ArrayList<>();

    /**
     * Adds a new entry to {@link #items}
     *
     * @param item
     *            Item to be added
     */
    public void addItem(ExceptionReportItem item) {
        items.add(item);
    }

    public List<ExceptionReportItem> getItems() {
        return items;
    }

    public void setItems(List<ExceptionReportItem> items) {
        this.items = items;
    }

    public String getTitle() {
        return title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public List<ExceptionReportRelevantPairData> getRelevantPairs() {
        return relevantPairs;
    }

    public void setRelevantPairs(List<ExceptionReportRelevantPairData> relevantPairs) {
        this.relevantPairs = relevantPairs;
    }

    public List<ExceptionReportRelevantComponentNode> getNodes() {
        return nodes;
    }

    public void setNodes(List<ExceptionReportRelevantComponentNode> nodes) {
        this.nodes = nodes;
    }
}
