package VIEW_PACKAGE;

import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.button.Button;
import com.vaadin.flow.component.button.ButtonVariant;
import com.vaadin.flow.component.combobox.ComboBox;
import com.vaadin.flow.component.formlayout.FormLayout;
import com.vaadin.flow.component.html.H3;
import com.vaadin.flow.component.html.Main;
import com.vaadin.flow.component.notification.Notification;
import com.vaadin.flow.component.orderedlayout.HorizontalLayout;
import com.vaadin.flow.component.orderedlayout.VerticalLayout;
import com.vaadin.flow.component.textfield.TextField;
import com.vaadin.flow.data.binder.Binder;

public class StubView extends Main {

    private final VerticalLayout layout = new VerticalLayout();
    private final TextField street = new TextField("Street address");
    private final TextField postalCode = new TextField("Postal code");
    private final TextField city = new TextField("City");
    private final ComboBox<String> state = new ComboBox<>("State");
    private final ComboBox<String> country = new ComboBox<>("Country");
    private final Button cancel = new Button("Cancel");
    private final Button save = new Button("Save");
    
    private final Binder<SampleAddress> binder = new Binder<>(SampleAddress.class);

    public StubView() {
        addClassName("stub-view");

        layout.add(createTitle());
        layout.add(createFormLayout());
        layout.add(createButtonLayout());
        binder.setBean(new SampleAddress());
        binder.bindInstanceFields(this);
        clearForm();
        cancel.addClickListener(e -> clearForm());
        save.addClickListener(e -> {
            Notification.show(binder.getBean().getClass().getSimpleName() + " stored.");
            clearForm();
        });
        add(layout);
    }

    private Component createTitle() {
        return new H3("Address");
    }

    private Component createFormLayout() {
        FormLayout formLayout = new FormLayout();
        formLayout.add(street, 2);
        postalCode.setAllowedCharPattern("\\d");
        country.setItems("Country 1", "Country 2", "Country 3");
        state.setItems("State A", "State B", "State C", "State D");
        formLayout.add(postalCode, city, state, country);
        return formLayout;
    }

    private Component createButtonLayout() {
        HorizontalLayout buttonLayout = new HorizontalLayout();
        buttonLayout.addClassName("button-layout");
        save.addThemeVariants(ButtonVariant.LUMO_PRIMARY);
        buttonLayout.add(save);
        buttonLayout.add(cancel);
        return buttonLayout;
    }

    private void clearForm() {
        this.binder.readBean(new SampleAddress());
    }

    public static class SampleAddress {
        private String street;
        private String postalCode;
        private String city;
        private String state;
        private String country;

        public String getPostalCode() {
            return postalCode;
        }

        public void setPostalCode(String postalCode) {
            this.postalCode = postalCode;
        }

        public String getCountry() {
            return country;
        }

        public void setCountry(String country) {
            this.country = country;
        }

        public String getState() {
            return state;
        }

        public void setState(String state) {
            this.state = state;
        }

        public String getCity() {
            return city;
        }

        public void setCity(String city) {
            this.city = city;
        }

        public String getStreet() {
            return street;
        }

        public void setStreet(String street) {
            this.street = street;
        }
    }
}
