package com.vaadin.copilot.javarewriter;

import com.github.javaparser.ast.expr.AssignExpr;
import com.github.javaparser.ast.expr.ObjectCreationExpr;
import com.github.javaparser.ast.stmt.BlockStmt;

/**
 * Represents metadata related to the creation of a component within a Java
 * source file.
 * <p>
 * This record holds the source context and the corresponding file where the
 * component is created.
 */
public class ComponentCreateInfo extends AbstractComponentLocationInfo {
    private BlockStmt componentCreateScope;
    private AssignExpr assignmentExpression;
    private ObjectCreationExpr objectCreationExpr;

    public ComponentCreateInfo(JavaSource javaSource) {
        super(javaSource);
    }

    public BlockStmt getComponentCreateScope() {
        return componentCreateScope;
    }

    public void setComponentCreateScope(BlockStmt componentCreateScope) {
        this.componentCreateScope = componentCreateScope;
    }

    public AssignExpr getAssignmentExpression() {
        return assignmentExpression;
    }

    public void setAssignmentExpression(AssignExpr assignmentExpression) {
        this.assignmentExpression = assignmentExpression;
    }

    public ObjectCreationExpr getObjectCreationExpr() {
        return objectCreationExpr;
    }

    public void setObjectCreationExpr(ObjectCreationExpr objectCreationExpr) {
        this.objectCreationExpr = objectCreationExpr;
    }
}
