package com.vaadin.copilot.ide;

import java.util.List;

/**
 * Represents the response payload from the IDE heartbeat mechanism.
 * <p>
 * This response provides information about the current compilation status of
 * the project and optionally a list of files that contain compilation errors.
 * It is used to communicate IDE state back to development tools for status
 * monitoring or UI feedback.
 *
 * @param hasCompilationError
 *            a Boolean indicating whether there is a compilation error; may be
 *            {@code null} if the status is unknown
 * @param filesContainCompilationErrors
 *            a list of file paths that currently contain compilation errors;
 *            may be {@code null} or empty if no errors are present
 */
public record IDEHeartbeatResponse(Boolean hasCompilationError, List<String> filesContainCompilationErrors) {

}
