package com.vaadin.copilot.exception.report;

import java.io.File;

/**
 * Represents a file-based item within an {@link ExceptionReport}.
 * <p>
 * This implementation of {@link ExceptionReportItem} encapsulates a file's name
 * and its textual content. It can be used to attach configuration files, logs,
 * or other relevant data to an exception report.
 */

public class ExceptionReportFileItem implements ExceptionReportItem {
    private final String name;
    private final String content;

    /**
     * Constructs a new {@code ExceptionReportFileItem} with the specified file and
     * content.
     *
     * @param fileName
     *            the name of the file being represented
     * @param content
     *            the textual content of the file
     */
    public ExceptionReportFileItem(String fileName, String content) {
        this.name = fileName;
        this.content = content;
    }

    public ExceptionReportFileItem(File file, String content) {
        this(file.getName(), content);
    }

    @Override
    public String getName() {
        return name;
    }

    @Override
    public String getContent() {
        return content;
    }
}
