package com.vaadin.copilot;

import java.io.InputStream;
import java.util.HashMap;

import com.vaadin.flow.internal.JsonDecodingException;

import tools.jackson.core.JacksonException;
import tools.jackson.core.type.TypeReference;
import tools.jackson.databind.DeserializationFeature;
import tools.jackson.databind.JsonNode;
import tools.jackson.databind.json.JsonMapper;
import tools.jackson.databind.node.ArrayNode;

// missing Flow JacksonUtils methods used in Copilot
public class CopilotJacksonUtils {

    private static final JsonMapper objectMapper = JsonMapper.builder()
            .configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false).build();

    public static JsonMapper getObjectMapper() {
        return objectMapper;
    }

    public static <T> T readValue(String string, Class<T> clazz) {
        try {
            return objectMapper.readValue(string, clazz);
        } catch (JacksonException e) {
            throw new IllegalArgumentException("Invalid data", e);
        }
    }

    public static <T> T readValue(InputStream in, Class<T> clazz) {
        try {
            return objectMapper.readValue(in, clazz);
        } catch (JacksonException e) {
            throw new IllegalArgumentException("Invalid data", e);
        }
    }

    public static <T> T readValue(InputStream in, TypeReference<T> typeReference) {
        try {
            return objectMapper.readValue(in, typeReference);
        } catch (JacksonException e) {
            throw new IllegalArgumentException("Invalid data", e);
        }
    }

    public static String writeValueAsString(Object value) {
        try {
            return objectMapper.writeValueAsString(value);
        } catch (JacksonException e) {
            throw new IllegalArgumentException("Invalid data", e);
        }
    }

    public static ArrayNode readArray(String json) {
        try {
            return (ArrayNode) objectMapper.readTree(json);
        } catch (JacksonException e) {
            throw new JsonDecodingException("Could not parse json content", e);
        }
    }

    public static HashMap<String, String> toMap(JsonNode data) {
        if (data == null) {
            return null;
        }
        return objectMapper.convertValue(data, new TypeReference<>() {
        });
    }

}
