package com.vaadin.copilot.feedback;

import java.net.URI;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.util.Map;

import com.vaadin.copilot.CopilotServerClient;

public class FeedbackClient extends CopilotServerClient {

    protected void sendFeedback(String userKey, String proKey, Map<String, String> data) {
        URI uri = getQueryURI("feedback");
        HttpRequest request = buildRequest(uri, new FeedbackRequest(userKey, proKey, data));
        getHttpClient().sendAsync(request, HttpResponse.BodyHandlers.ofString());
    }
}
