package com.vaadin.copilot.customcomponent;

import com.vaadin.copilot.javarewriter.ComponentTypeAndSourceLocation;

/**
 * Contains information for each node instance that is required for custom
 * component support.
 */
public class ComponentInfoForCustomComponentSupport {
    protected String createLocationPath;
    protected String createdClassName;
    private boolean childOfCustomComponent;
    private boolean routeView;

    /**
     * Default constructor
     */
    public ComponentInfoForCustomComponentSupport() {
    }

    /**
     * Constructs the {@link ComponentInfoForCustomComponentSupport} with
     * createLocationPath
     *
     * @param createLocationPath
     *            file path where component instance is created e.g.
     *            {@link ComponentTypeAndSourceLocation#getCreateLocationOrThrow()}
     */
    public ComponentInfoForCustomComponentSupport(String createLocationPath) {
        this.createLocationPath = createLocationPath;
    }

    public String getCreateLocationPath() {
        return createLocationPath;
    }

    public void setCreateLocationPath(String createLocationPath) {
        this.createLocationPath = createLocationPath;
    }

    public boolean isChildOfCustomComponent() {
        return childOfCustomComponent;
    }

    public void setChildOfCustomComponent(boolean childOfCustomComponent) {
        this.childOfCustomComponent = childOfCustomComponent;
    }

    public boolean isRouteView() {
        return routeView;
    }

    public void setRouteView(boolean routeView) {
        this.routeView = routeView;
    }

    public String getCreatedClassName() {
        return createdClassName;
    }

    public void setCreatedClassName(String createdClassName) {
        this.createdClassName = createdClassName;
    }
}
