package com.vaadin.copilot.userinfo;

/**
 * Thrown when the user tries to use some AI functionality but AI usage is
 * disabled (either through the subscription or by the user).
 * <p>
 * Mostly should never be thrown as the UI should prevent the user from
 * triggering AI functionality in these cases.
 */
public class AIUsageDisabledException extends RuntimeException {

    /**
     * Creates a new exception with the default message.
     */
    public AIUsageDisabledException() {
        super("AI usage is disabled");
    }
}
