package com.vaadin.copilot.plugins.themeeditor;

import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.function.Function;

import com.vaadin.copilot.ComponentSourceFinder;
import com.vaadin.copilot.ProjectFileManager;
import com.vaadin.copilot.ide.CopilotIDEPlugin;
import com.vaadin.flow.server.VaadinSession;

import com.github.javaparser.ast.CompilationUnit;
import com.github.javaparser.printer.lexicalpreservation.LexicalPreservingPrinter;

/** Editor extension to write file content */
public class CopilotEditor extends Editor {

    private static final String COPILOT_FILE_UPDATE_UNDO_LABEL = CopilotIDEPlugin.undoLabel("File Update");

    protected final ComponentSourceFinder sourceFinder;
    private final VaadinSession vaadinSession;

    public CopilotEditor(VaadinSession session) {
        this.sourceFinder = new ComponentSourceFinder(session);
        this.vaadinSession = session;
    }

    protected VaadinSession getVaadinSession() {
        return vaadinSession;
    }

    @Override
    public int modifyClass(File f, Function<CompilationUnit, List<Modification>> modifier) {
        try {
            String source = ProjectFileManager.get().readFile(f);
            CompilationUnit cu = this.parseSource(source);
            List<Modification> mods = modifier.apply(cu);
            Collections.sort(mods);
            int sourceOffset = 0;

            Modification mod;
            for (Iterator var7 = mods.iterator(); var7.hasNext(); sourceOffset += mod.sourceOffset()) {
                mod = (Modification) var7.next();
                mod.apply();
            }

            String newSource = LexicalPreservingPrinter.print(cu);
            if (newSource.equals(source)) {
                throw new UnsupportedOperationException("Unable to edit file");
            } else {
                ProjectFileManager.get().writeFile(f, COPILOT_FILE_UPDATE_UNDO_LABEL, newSource);
                return sourceOffset;
            }
        } catch (IOException var13) {
            throw new UnsupportedOperationException(var13);
        }
    }
}
