package com.vaadin.copilot.javarewriter;

import com.github.javaparser.ast.body.FieldDeclaration;
import com.github.javaparser.ast.body.VariableDeclarator;

/**
 * An abstract base class that holds common information about a component
 * extracted from Java source code during code analysis.
 * <p>
 * This class provides basic metadata for components, such as their local
 * variable names, field declarations, and associated source information. It is
 * intended to be extended by more specialized component information classes
 * e.g. {@link ComponentCreateInfo} and {@link ComponentAttachInfo}
 * </p>
 */
public abstract class AbstractComponentLocationInfo {
    private final JavaSource javaSource;
    protected String localVariableName;
    protected VariableDeclarator localVariableDeclarator;
    protected String fieldName;
    protected FieldDeclaration fieldDeclaration;
    protected FieldDeclaration fieldDeclarationAndAssignment;

    /**
     * Creates a new {@code ComponentBaseInfo} with the specified Java source and
     * file reference.
     *
     * @param javaSource
     *            the {@link JavaSource} representing the parsed source code where
     *            the component is defined; must not be {@code null}.
     */
    protected AbstractComponentLocationInfo(JavaSource javaSource) {
        this.javaSource = javaSource;
    }

    public JavaSource getJavaSource() {
        return javaSource;
    }

    public VariableDeclarator getLocalVariableDeclarator() {
        return localVariableDeclarator;
    }

    public void setLocalVariableDeclarator(VariableDeclarator localVariableDeclarator) {
        this.localVariableDeclarator = localVariableDeclarator;
    }

    public FieldDeclaration getFieldDeclaration() {
        return fieldDeclaration;
    }

    public void setFieldDeclaration(FieldDeclaration fieldDeclaration) {
        this.fieldDeclaration = fieldDeclaration;
    }

    public String getLocalVariableName() {
        return localVariableName;
    }

    public void setLocalVariableName(String localVariableName) {
        this.localVariableName = localVariableName;
    }

    public String getFieldName() {
        return fieldName;
    }

    public void setFieldName(String fieldName) {
        this.fieldName = fieldName;
    }

    public FieldDeclaration getFieldDeclarationAndAssignment() {
        return fieldDeclarationAndAssignment;
    }

    public void setFieldDeclarationAndAssignment(FieldDeclaration fieldDeclarationAndAssignment) {
        this.fieldDeclarationAndAssignment = fieldDeclarationAndAssignment;
    }
}
