package com.vaadin.copilot.analytics;

import com.vaadin.base.devserver.DevToolsInterface;
import com.vaadin.copilot.CopilotCommand;
import com.vaadin.copilot.CopilotJacksonUtils;

import tools.jackson.databind.JsonNode;

public class AnalyticsInterceptor extends CopilotCommand {

    @Override
    public boolean handleMessage(String command, JsonNode data, DevToolsInterface devToolsInterface) {
        if (command.equals("browser-info")) {
            AnalyticsClient.getInstance().setUserContext(CopilotJacksonUtils.toMap(data));
            return true;
        }
        if (command.equals("track-event")) {
            String event = data.get("event").asString();
            JsonNode properties = data.get("properties");
            AnalyticsClient.getInstance().track(event, CopilotJacksonUtils.toMap(properties));
            return true;
        }
        return false;
    }

}
