package com.vaadin.copilot;

import com.vaadin.base.devserver.DevToolsInterface;
import com.vaadin.flow.internal.JacksonUtils;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import tools.jackson.databind.JsonNode;
import tools.jackson.databind.node.ObjectNode;

public class ApplicationUserSwitchHandler extends CopilotCommand {

    @Override
    public boolean handleMessage(String command, JsonNode data, DevToolsInterface devToolsInterface) {
        if (command.equals("switch-user")) {
            String reqId = data.get(KEY_REQ_ID).asString();
            ObjectNode respData = JacksonUtils.createObjectNode();
            respData.put(KEY_REQ_ID, reqId);

            String username = data.get("username").asString();

            try {
                if (!SpringBridge.isSpringSecurityEnabled(getVaadinContext())) {
                    ErrorHandler.setErrorMessage(respData,
                            "This only works when Spring Security is in use in the project");
                } else {
                    SpringBridge.setActiveSpringSecurityUser(username, getVaadinSession());
                }
            } catch (Exception e) {
                if (e.getClass().getName()
                        .equals("org.springframework.security.core.userdetails.UsernameNotFoundException")) {
                    ErrorHandler.sendErrorResponse(devToolsInterface, command, respData, "Username not found", e);
                } else {
                    ErrorHandler.sendErrorResponse(devToolsInterface, command, respData, "Unable to switch user", e);
                    getLogger().error("Unable to switch user", e);
                }
                return true;
            }
            devToolsInterface.send(command + "-response", respData);
            return true;
        }
        return false;
    }

    private Logger getLogger() {
        return LoggerFactory.getLogger(getClass());
    }

}
