package com.vaadin.copilot;

import java.util.Arrays;

/**
 * Property types that properties panel supports
 */
public enum ComponentPropertyType {
    INTEGER, STRING, BOOLEAN, DOUBLE, LONG, FLOAT, SHORT, BYTE, CHARACTER, BIG_DECIMAL, BIG_INTEGER, ENUM;

    /**
     * Returns the {@link ComponentPropertyType} corresponding to the given Java
     * type name.
     * <p>
     * This method searches the available {@link ComponentPropertyType} enum values
     * to find a match where the enum's name exactly equals the provided
     * {@code javaType} string. If the input is {@code null} or no matching enum
     * constant is found, the method returns {@code null}.
     *
     * @param javaType
     *            the name of the Java type to find a matching
     *            {@link ComponentPropertyType} for; may be {@code null}
     * @return the matching {@link ComponentPropertyType} if found; otherwise
     *         {@code null}
     */
    public static ComponentPropertyType find(String javaType) {
        if (javaType == null) {
            return null;
        }
        return Arrays.stream(ComponentPropertyType.values()).filter(type -> type.name().equals(javaType)).findFirst()
                .orElse(null);

    }
}
