package com.vaadin.copilot.exception.report;

/**
 * A generic interface that represents what items should return for reporting an
 * issue. Each item represents a section in a GH issue.
 */
public interface ExceptionReportItem {
    /**
     * Name or description of the item. Name is used for section header in GitHub.
     *
     * @return the name e.g. HelloWorldView.java
     */
    String getName();

    /**
     * Content of the item.
     *
     * @return the content. e.g. class source or stack trace
     */
    String getContent();
}
