package com.vaadin.copilot.ide;

import com.vaadin.flow.internal.JacksonUtils;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;

public record IdeNotification(String message, Type type, String dismissId) {

    public enum Type {
        INFORMATION, WARNING, ERROR

    }

    public JsonNode asJson() {
        ObjectNode object = JacksonUtils.createObjectNode();
        object.put("message", message);
        object.put("type", type.name());
        object.put("dismissId", dismissId);
        return object;
    }
}
