package com.vaadin.copilot.plugins.testgeneration;

import java.io.IOException;
import java.net.URI;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.util.HashMap;
import java.util.Map;

import com.vaadin.copilot.CopilotServerClient;
import com.vaadin.copilot.CopilotVersion;
import com.vaadin.copilot.ai.AIConstants;
import com.vaadin.pro.licensechecker.ProKey;
import com.vaadin.uitest.model.UiLogin;
import com.vaadin.uitest.model.UiRoute;

public class TestGenerationServerClient extends CopilotServerClient {

    public String generateTests(ProKey proKey, String machineId, UiRoute view, UiLogin login)
            throws IOException, InterruptedException {
        URI uri = getQueryURI("generateTests");
        Map<String, String> metadata = new HashMap<>();
        if (proKey != null) {
            metadata.put(AIConstants.PRO_KEY_KEY, proKey.toJson());
        }
        if (machineId != null) {
            metadata.put(AIConstants.MACHINE_ID_KEY, machineId);
        }
        metadata.put(AIConstants.VERSION_KEY, CopilotVersion.getVersion());
        TestGenerationRequest requestData = new TestGenerationRequest(view, login, metadata);
        String json = writeAsJsonString(requestData);
        HttpRequest request = buildRequest(uri, json);
        HttpResponse<String> response = getHttpClient().send(request, HttpResponse.BodyHandlers.ofString());
        if (response.statusCode() != 200) {
            throw new IOException("Incorrect Response from server: " + response.statusCode() + " " + response.uri()
                    + " " + response.body());
        }
        return response.body();
    }
}
