package com.vaadin.copilot.plugins.accessibilitychecker;

import com.vaadin.base.devserver.DevToolsInterface;
import com.vaadin.copilot.CopilotCommand;

import elemental.json.Json;
import elemental.json.JsonObject;

/** @author jcgueriaud */
public class AccessibilityCheckerMessageHandler extends CopilotCommand {

    public static final String ACCESSIBILITY_CHECKER = "a11y-checker";
    public static final String UI_ID = "uiId";

    private final AccessibilityJavaSourceModifier accessibilityJavaSourceModifier;

    public AccessibilityCheckerMessageHandler() {
        accessibilityJavaSourceModifier = new AccessibilityJavaSourceModifier(getVaadinSession(),
                (devToolsInterface, errorMessage) -> {
                    JsonObject object = Json.createObject();
                    object.put("message", errorMessage);
                    devToolsInterface.send(ACCESSIBILITY_CHECKER + "-error", object);
                }, (devToolsInterface) -> {
                    JsonObject object = Json.createObject();
                    devToolsInterface.send(ACCESSIBILITY_CHECKER + "-success", object);
                });

    }

    @Override
    public boolean handleMessage(String command, JsonObject data, DevToolsInterface devToolsInterface) {
        if (command.equals(ACCESSIBILITY_CHECKER + "-update-page-title")) {
            int uiId = (int) data.getNumber(UI_ID);
            String label = data.getString("label");
            accessibilityJavaSourceModifier.setPageTitle(devToolsInterface, uiId, label);
            return true;
        }
        return false;
    }
}
