package com.vaadin.copilot.ai;

import java.util.Base64;

import com.vaadin.base.devserver.DevToolsInterface;
import com.vaadin.copilot.CopilotCommand;
import com.vaadin.copilot.CopilotServerClient;
import com.vaadin.copilot.userinfo.UserInfoServerClient;
import com.vaadin.flow.internal.JacksonUtils;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;

public class CreateLumoThemeVariablesHandler extends CopilotCommand {

    private final CopilotServerClient copilotServerClient = new CopilotServerClient();

    public record CreateLumoThemeVariableData(byte[] imageData, String mimeType) {
    }

    public record CreateLumoThemeVariableRequest(CreateLumoThemeVariableData data,
            CopilotServerClient.AccessControlData accessControlData) {
    }

    public record CreateLumoThemeVariableResponse(String css) {
    }

    @Override
    public boolean handleMessage(String command, JsonNode data, DevToolsInterface devToolsInterface) {
        if (command.equals("ai-create-lumo-theme-variables")) {
            UserInfoServerClient.throwIfAIUsageDisabled();
            ObjectNode respData = JacksonUtils.createObjectNode();
            respData.put(CopilotCommand.KEY_REQ_ID, data.get(CopilotCommand.KEY_REQ_ID).asText());

            byte[] imageData = Base64.getDecoder().decode(data.get("imageBase64").asText());
            CreateLumoThemeVariableRequest request = new CreateLumoThemeVariableRequest(
                    new CreateLumoThemeVariableData(imageData, data.get("imageMimeType").asText()),
                    CopilotServerClient.AccessControlData.create());

            copilotServerClient.sendCopilotRequest("create-lumo-theme-variables", request,
                    CreateLumoThemeVariableResponse.class, response -> {
                        respData.put("css", response.css());
                        devToolsInterface.send(command + "-resp", respData);
                    }, devToolsInterface, command, respData);
            return true;
        }
        return false;
    }

}