/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.controlcenter.starter;

import org.springframework.boot.actuate.availability.AvailabilityStateHealthIndicator;
import org.springframework.boot.actuate.health.Status;
import org.springframework.boot.availability.ApplicationAvailability;
import org.springframework.boot.availability.AvailabilityChangeEvent;
import org.springframework.boot.availability.AvailabilityState;
import org.springframework.boot.context.event.ApplicationStartedEvent;
import org.springframework.context.ApplicationContext;
import org.springframework.context.event.EventListener;

public class StartupStateHealthIndicator
extends AvailabilityStateHealthIndicator {
    StartupStateHealthIndicator(ApplicationAvailability availability) {
        super(availability, StartupState.class, statusMappings -> {
            statusMappings.add((AvailabilityState)StartupState.STARTED, Status.UP);
            statusMappings.add((AvailabilityState)StartupState.UNKNOWN, Status.UNKNOWN);
        });
    }

    @EventListener
    void applicationStarted(ApplicationStartedEvent event) {
        AvailabilityChangeEvent.publish((ApplicationContext)event.getApplicationContext(), (AvailabilityState)StartupState.STARTED);
    }

    protected AvailabilityState getState(ApplicationAvailability applicationAvailability) {
        return applicationAvailability.getState(StartupState.class, (AvailabilityState)StartupState.UNKNOWN);
    }

    static enum StartupState implements AvailabilityState
    {
        STARTED,
        UNKNOWN;

    }
}

