/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.controlcenter.starter;

import com.vaadin.controlcenter.starter.ControlCenterProperties;
import com.vaadin.controlcenter.starter.KubernetesBackChannelLogoutHandler;
import com.vaadin.flow.spring.security.VaadinSecurityConfigurer;
import java.util.Objects;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.security.config.annotation.SecurityConfigurerAdapter;
import org.springframework.security.config.annotation.web.builders.HttpSecurity;
import org.springframework.security.config.annotation.web.configurers.AbstractHttpConfigurer;
import org.springframework.security.config.annotation.web.configurers.oauth2.client.OidcLogoutConfigurer;
import org.springframework.security.web.authentication.logout.LogoutHandler;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public final class ControlCenterSecurityConfigurer
extends AbstractHttpConfigurer<ControlCenterSecurityConfigurer, HttpSecurity> {
    private static final String MISSING_REGISTRATION_ID = "The registrationId cannot be empty. When using ControlCenterSecurityConfigurer the registrationId property\nneeds to be provided setting vaadin.control-center.registration-id in the application.properties (or .yaml)\nfile, or in the app's Kubernetes ConfigMap (or Secret). The property is configured automatically when the\napp is deployed to Kubernetes using with Control Center and spec.keycloak.realm is defined.\n";
    private static final String MISSING_APPLICATION_CONTEXT = "No ApplicationContext available. Make sure to add the configurer to the HttpSecurity builder using the\nwith(configurer, customizer) method.\n";
    private static final Logger LOGGER = LoggerFactory.getLogger(ControlCenterSecurityConfigurer.class);

    private ControlCenterSecurityConfigurer() {
    }

    public static ControlCenterSecurityConfigurer controlCenter() {
        return new ControlCenterSecurityConfigurer();
    }

    public void init(HttpSecurity http) throws Exception {
        String registrationId = this.getProperties().getRegistrationId();
        if (StringUtils.hasText((String)registrationId)) {
            ((HttpSecurity)http.with((SecurityConfigurerAdapter)this.getVaadinSecurityConfigurer(), this::customize)).oidcLogout(this::customize);
        } else {
            LOGGER.warn("No registrationId provided. Skipping Control Center security configuration.");
        }
    }

    private void customize(VaadinSecurityConfigurer configurer) {
        String registrationId = this.getProperties().getRegistrationId();
        Assert.hasText((String)registrationId, (String)MISSING_REGISTRATION_ID);
        configurer.oauth2LoginPage("/oauth2/authorization/" + registrationId);
    }

    private void customize(OidcLogoutConfigurer<HttpSecurity> configurer) {
        KubernetesBackChannelLogoutHandler logoutHandler = this.getSharedObjectOrBean(KubernetesBackChannelLogoutHandler.class);
        if (logoutHandler != null) {
            configurer.backChannel(bc -> bc.logoutHandler((LogoutHandler)logoutHandler));
        }
    }

    private VaadinSecurityConfigurer getVaadinSecurityConfigurer() {
        VaadinSecurityConfigurer existingConfigurer = (VaadinSecurityConfigurer)((HttpSecurity)this.getBuilder()).getConfigurer(VaadinSecurityConfigurer.class);
        return Objects.requireNonNullElseGet(existingConfigurer, VaadinSecurityConfigurer::vaadin);
    }

    private ControlCenterProperties getProperties() {
        return this.getSharedObjectOrBean(ControlCenterProperties.class);
    }

    private <T> T getSharedObjectOrBean(Class<T> type) {
        Object sharedObject = ((HttpSecurity)this.getBuilder()).getSharedObject(type);
        return (T)Optional.ofNullable(sharedObject).orElseGet(() -> {
            ApplicationContext applicationContext = (ApplicationContext)((HttpSecurity)this.getBuilder()).getSharedObject(ApplicationContext.class);
            Assert.notNull((Object)applicationContext, (String)MISSING_APPLICATION_CONTEXT);
            return applicationContext.getBeanProvider(type).getIfAvailable();
        });
    }
}

