// Copyright (C) 2025 Vaadin Ltd
// This program is available under Vaadin Commercial License and Service Terms.
// See <https://vaadin.com/commercial-license-and-service-terms> for the full license.
package com.vaadin.controlcenter.starter;

import org.springframework.boot.actuate.availability.AvailabilityStateHealthIndicator;
import org.springframework.boot.actuate.health.Status;
import org.springframework.boot.availability.ApplicationAvailability;
import org.springframework.boot.availability.AvailabilityChangeEvent;
import org.springframework.boot.availability.AvailabilityState;
import org.springframework.boot.context.event.ApplicationStartedEvent;
import org.springframework.context.event.EventListener;

/// A [org.springframework.boot.actuate.health.HealthIndicator] that checks the [StartupState] of the application.
public class StartupStateHealthIndicator extends AvailabilityStateHealthIndicator {

    enum StartupState implements AvailabilityState {
        STARTED,
        UNKNOWN;
    }

    StartupStateHealthIndicator(ApplicationAvailability availability) {
        super(availability, StartupState.class, statusMappings -> {
            statusMappings.add(StartupState.STARTED, Status.UP);
            statusMappings.add(StartupState.UNKNOWN, Status.UNKNOWN);
        });
    }

    @EventListener
    void applicationStarted(ApplicationStartedEvent event) {
        AvailabilityChangeEvent.publish(event.getApplicationContext(), StartupState.STARTED);
    }

    @Override
    protected AvailabilityState getState(ApplicationAvailability applicationAvailability) {
        return applicationAvailability.getState(StartupState.class, StartupState.UNKNOWN);
    }
}
