/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.controlcenter.starter;

import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.kubernetes.api.model.Pod;
import io.fabric8.kubernetes.api.model.PodList;
import io.fabric8.kubernetes.client.KubernetesClient;
import io.fabric8.kubernetes.client.dsl.FilterWatchListDeletable;
import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cloud.kubernetes.commons.PodUtils;
import org.springframework.security.core.Authentication;
import org.springframework.security.web.authentication.logout.LogoutHandler;
import org.springframework.web.client.RestClient;
import org.springframework.web.util.UriComponentsBuilder;

class KubernetesBackChannelLogoutHandler
implements LogoutHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(KubernetesBackChannelLogoutHandler.class);
    private static final String BROADCAST_HEADER = "X-OIDC-BackChannel-Logout-Broadcast";
    private final KubernetesClient kubernetesClient;
    private final PodUtils<Pod> podUtils;
    private final LogoutHandler delegate;
    private final RestClient restClient;

    KubernetesBackChannelLogoutHandler(RestClient.Builder restClientBuilder, KubernetesClient kubernetesClient, PodUtils<Pod> podUtils, LogoutHandler delegate) {
        this.kubernetesClient = kubernetesClient;
        this.podUtils = podUtils;
        this.delegate = delegate;
        this.restClient = restClientBuilder.build();
    }

    public void logout(HttpServletRequest request, HttpServletResponse response, Authentication authentication) {
        String broadcastHeader = request.getHeader(BROADCAST_HEADER);
        if (this.podUtils.isInsideKubernetes() && broadcastHeader == null) {
            LOGGER.debug("No broadcast header in OIDC Back-Channel Logout request, broadcasting request to pods");
            ObjectMeta metadata = ((Pod)this.podUtils.currentPod().get()).getMetadata();
            String namespace = metadata.getNamespace();
            Map labels = metadata.getLabels();
            String token = request.getParameter("logout_token");
            ((PodList)((FilterWatchListDeletable)((NonNamespaceOperation)this.kubernetesClient.pods().inNamespace(namespace)).withLabels(labels)).list()).getItems().forEach(pod -> {
                String ip = pod.getStatus().getPodIP();
                LOGGER.debug("Broadcasting OIDC Back-Channel Logout request to Pod with IP {}", (Object)ip);
                String uri = UriComponentsBuilder.fromUriString((String)request.getRequestURI()).scheme("http").host(ip).port(8080).queryParam("logout_token", new Object[]{token}).toUriString();
                ((RestClient.RequestBodySpec)((RestClient.RequestBodySpec)this.restClient.post().uri(uri, new Object[0])).header(BROADCAST_HEADER, new String[]{"true"})).retrieve().toBodilessEntity();
            });
        } else if (!this.podUtils.isInsideKubernetes() || broadcastHeader != null) {
            LOGGER.debug("Found broadcast header in OIDC Back-Channel Logout request (or not inside Kubernetes)");
            this.delegate.logout(request, response, authentication);
        }
    }
}

