/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.controlcenter.starter;

import com.vaadin.flow.component.HeartbeatEvent;
import com.vaadin.flow.component.HeartbeatListener;
import com.vaadin.flow.server.ServiceInitEvent;
import com.vaadin.flow.server.UIInitListener;
import com.vaadin.flow.spring.security.AuthenticationContext;
import java.io.Serializable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.event.EventListener;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolderStrategy;
import org.springframework.security.oauth2.client.OAuth2AuthorizeRequest;
import org.springframework.security.oauth2.client.OAuth2AuthorizedClient;
import org.springframework.security.oauth2.client.OAuth2AuthorizedClientManager;
import org.springframework.security.oauth2.client.OAuth2AuthorizedClientService;
import org.springframework.security.oauth2.client.authentication.OAuth2AuthenticationToken;

class KeycloakSessionRefreshHeartbeatListener
implements HeartbeatListener {
    private static final Logger LOGGER = LoggerFactory.getLogger(KeycloakSessionRefreshHeartbeatListener.class);
    private final transient SecurityContextHolderStrategy securityContextHolderStrategy;
    private final transient OAuth2AuthorizedClientService clientService;
    private final transient OAuth2AuthorizedClientManager clientManager;
    private final transient AuthenticationContext authenticationContext;

    KeycloakSessionRefreshHeartbeatListener(SecurityContextHolderStrategy securityContextHolderStrategy, OAuth2AuthorizedClientService clientService, OAuth2AuthorizedClientManager clientManager, AuthenticationContext authenticationContext) {
        this.securityContextHolderStrategy = securityContextHolderStrategy;
        this.clientService = clientService;
        this.clientManager = clientManager;
        this.authenticationContext = authenticationContext;
    }

    @EventListener
    void serviceInit(ServiceInitEvent serviceInitEvent) {
        LOGGER.debug("Service initialized, registering heartbeat listener");
        serviceInitEvent.getSource().addUIInitListener((UIInitListener & Serializable)uiInitEvent -> uiInitEvent.getUI().addHeartbeatListener((HeartbeatListener)this));
    }

    public void heartbeat(HeartbeatEvent event) {
        LOGGER.debug("Heartbeat received, attempting to refresh OIDC Session");
        Authentication auth = this.securityContextHolderStrategy.getContext().getAuthentication();
        if (auth instanceof OAuth2AuthenticationToken) {
            OAuth2AuthenticationToken token = (OAuth2AuthenticationToken)auth;
            String registrationId = token.getAuthorizedClientRegistrationId();
            OAuth2AuthorizedClient client = this.clientService.loadAuthorizedClient(registrationId, token.getName());
            if (client == null) {
                LOGGER.warn("Could not find authorized client for registrationId {}, forcing logout", (Object)registrationId);
                this.authenticationContext.logout();
                return;
            }
            OAuth2AuthorizeRequest authorizeRequest = OAuth2AuthorizeRequest.withClientRegistrationId((String)registrationId).principal((Authentication)token).build();
            OAuth2AuthorizedClient newClient = this.clientManager.authorize(authorizeRequest);
            if (newClient == null) {
                LOGGER.warn("Refresh attempt failed for registrationId {}, forcing logout", (Object)registrationId);
                this.authenticationContext.logout();
                return;
            }
            LOGGER.debug("Refresh attempt successful for registrationId {}", (Object)registrationId);
            this.clientService.saveAuthorizedClient(newClient, (Authentication)token);
        }
    }
}

