/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.controlcenter.starter;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.vaadin.controlcenter.starter.ControlCenterProperties;
import com.vaadin.controlcenter.starter.KeycloakSessionRefreshHeartbeatListener;
import com.vaadin.controlcenter.starter.KeycloakUserMapper;
import com.vaadin.controlcenter.starter.KubernetesBackChannelLogoutHandler;
import com.vaadin.controlcenter.starter.ReadinessStateSignalHandler;
import com.vaadin.controlcenter.starter.StartupStateHealthIndicator;
import com.vaadin.controlcenter.starter.VaadinActuatorEndpoint;
import com.vaadin.flow.spring.security.AuthenticationContext;
import com.vaadin.flow.spring.security.VaadinAwareSecurityContextHolderStrategy;
import io.fabric8.kubernetes.api.model.Pod;
import io.fabric8.kubernetes.client.KubernetesClient;
import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;
import org.springframework.aot.hint.annotation.RegisterReflectionForBinding;
import org.springframework.boot.actuate.autoconfigure.security.servlet.EndpointRequest;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnCloudPlatform;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.availability.ApplicationAvailability;
import org.springframework.boot.cloud.CloudPlatform;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.kubernetes.commons.PodUtils;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.core.annotation.Order;
import org.springframework.security.config.annotation.web.builders.HttpSecurity;
import org.springframework.security.config.annotation.web.configurers.AuthorizeHttpRequestsConfigurer;
import org.springframework.security.config.annotation.web.configurers.oauth2.client.OidcBackChannelLogoutHandler;
import org.springframework.security.core.context.SecurityContextHolderStrategy;
import org.springframework.security.oauth2.client.OAuth2AuthorizedClientManager;
import org.springframework.security.oauth2.client.OAuth2AuthorizedClientService;
import org.springframework.security.oauth2.client.oidc.session.InMemoryOidcSessionRegistry;
import org.springframework.security.oauth2.client.oidc.session.OidcSessionRegistry;
import org.springframework.security.oauth2.client.oidc.userinfo.OidcUserService;
import org.springframework.security.oauth2.client.registration.ClientRegistration;
import org.springframework.security.oauth2.client.registration.ClientRegistrationRepository;
import org.springframework.security.oauth2.client.registration.ClientRegistrations;
import org.springframework.security.oauth2.client.registration.InMemoryClientRegistrationRepository;
import org.springframework.security.oauth2.client.registration.SupplierClientRegistrationRepository;
import org.springframework.security.web.SecurityFilterChain;
import org.springframework.security.web.authentication.logout.LogoutHandler;
import org.springframework.security.web.util.matcher.RequestMatcher;
import org.springframework.util.Assert;
import org.springframework.web.client.RestClient;

@AutoConfiguration
@EnableConfigurationProperties(value={ControlCenterProperties.class})
public class ControlCenterConfiguration {
    static final ParameterizedTypeReference<Map<String, Object>> METADATA_TYPE = new ParameterizedTypeReference<Map<String, Object>>(){};
    static final ObjectMapper MAPPER = new ObjectMapper();
    private final ControlCenterProperties properties;
    private final RestClient restClient;

    ControlCenterConfiguration(ControlCenterProperties properties, RestClient.Builder restClientBuilder) {
        this.properties = properties;
        this.restClient = restClientBuilder.build();
    }

    @Bean
    KeycloakSessionRefreshHeartbeatListener oidcRefreshHeartbeatListener(SecurityContextHolderStrategy securityContextHolderStrategy, OAuth2AuthorizedClientService clientService, OAuth2AuthorizedClientManager clientManager, AuthenticationContext authenticationContext) {
        return new KeycloakSessionRefreshHeartbeatListener(securityContextHolderStrategy, clientService, clientManager, authenticationContext);
    }

    @Bean
    @ConditionalOnMissingBean
    SecurityContextHolderStrategy securityContextHolderStrategy() {
        return new VaadinAwareSecurityContextHolderStrategy();
    }

    @Bean
    @ConditionalOnMissingBean
    OidcSessionRegistry oidcSessionRegistry() {
        return new InMemoryOidcSessionRegistry();
    }

    @Bean
    @ConditionalOnCloudPlatform(value=CloudPlatform.KUBERNETES)
    KubernetesBackChannelLogoutHandler backChannelLogoutHandler(RestClient.Builder restClientBuilder, KubernetesClient kubernetesClient, PodUtils<Pod> podUtils, OidcSessionRegistry sessionRegistry) {
        OidcBackChannelLogoutHandler delegate = new OidcBackChannelLogoutHandler(sessionRegistry);
        return new KubernetesBackChannelLogoutHandler(restClientBuilder, kubernetesClient, podUtils, (LogoutHandler)delegate);
    }

    @Bean
    @ConditionalOnCloudPlatform(value=CloudPlatform.KUBERNETES)
    ReadinessStateSignalHandler readinessStateSignalHandler(ApplicationContext applicationContext) {
        return new ReadinessStateSignalHandler(applicationContext);
    }

    @Bean
    @ConditionalOnCloudPlatform(value=CloudPlatform.KUBERNETES)
    StartupStateHealthIndicator startupStateHealthIndicator(ApplicationAvailability availability) {
        return new StartupStateHealthIndicator(availability);
    }

    @Bean
    @RegisterReflectionForBinding(value={VaadinActuatorEndpoint.VaadinInfo.class})
    VaadinActuatorEndpoint vaadinActuatorEndpoint() {
        return new VaadinActuatorEndpoint();
    }

    @Bean
    @ConditionalOnMissingBean
    OidcUserService keycloakUserService() {
        OidcUserService oidcUserService = new OidcUserService();
        oidcUserService.setOidcUserMapper((BiFunction)new KeycloakUserMapper(MAPPER));
        return oidcUserService;
    }

    @Bean
    @Order(value=-2147483648)
    SecurityFilterChain actuatorSecurityFilterChain(HttpSecurity http) throws Exception {
        return (SecurityFilterChain)http.securityMatcher((RequestMatcher)EndpointRequest.toAnyEndpoint()).authorizeHttpRequests(authorize -> ((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)authorize.anyRequest()).permitAll()).build();
    }

    @Bean
    @ConditionalOnMissingBean
    ClientRegistrationRepository clientRegistrationRepository() {
        return new SupplierClientRegistrationRepository(this::lazyClientRegistrationRepository);
    }

    InMemoryClientRegistrationRepository lazyClientRegistrationRepository() {
        String clientId = this.properties.getClientId();
        String clientSecret = this.properties.getClientSecret();
        String registrationId = this.properties.getRegistrationId();
        String issuerBackendUri = this.properties.getIssuerBackendUri();
        String issuerFrontendUri = this.properties.getIssuerFrontendUri();
        String wellKnownConfigurationUri = issuerBackendUri + "/.well-known/openid-configuration";
        Map metadata = (Map)this.restClient.get().uri(wellKnownConfigurationUri, new Object[0]).retrieve().body(METADATA_TYPE);
        Assert.notNull((Object)metadata, (String)this.couldNotRetrieveMetadata(wellKnownConfigurationUri));
        String metadataIssuer = (String)metadata.get("issuer");
        Assert.state((boolean)issuerFrontendUri.equals(metadataIssuer), (String)this.issuerMismatch(metadataIssuer, issuerFrontendUri));
        ClientRegistration registration = ClientRegistrations.fromOidcConfiguration((Map)metadata).clientId(clientId).clientSecret(clientSecret).registrationId(registrationId).scope(this.properties.getClientScope()).build();
        return new InMemoryClientRegistrationRepository(List.of(registration));
    }

    private String couldNotRetrieveMetadata(String issuerUri) {
        return "Could not retrieve metadata from issuer at " + issuerUri;
    }

    private String issuerMismatch(String metadataIssuer, String expectedIssuer) {
        return "The issuer '%s' provided in the configuration metadata did not match the expected issuer '%s'".formatted(metadataIssuer, expectedIssuer);
    }
}

