/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.controlcenter.starter;

import com.vaadin.flow.server.ServiceInitEvent;
import com.vaadin.flow.server.SessionDestroyEvent;
import com.vaadin.flow.server.SessionInitEvent;
import com.vaadin.flow.server.VaadinService;
import com.vaadin.flow.server.VaadinSession;
import com.vaadin.flow.server.Version;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.actuate.endpoint.annotation.Endpoint;
import org.springframework.boot.actuate.endpoint.annotation.ReadOperation;
import org.springframework.context.event.EventListener;

@Endpoint(id="vaadin")
public class VaadinActuatorEndpoint {
    public static final String ENDPOINT_ID = "vaadin";
    private static final Logger LOGGER = LoggerFactory.getLogger(VaadinActuatorEndpoint.class);
    private final AtomicInteger counter = new AtomicInteger();

    VaadinActuatorEndpoint() {
    }

    @EventListener
    void serviceInit(ServiceInitEvent serviceInitEvent) {
        LOGGER.debug("Service initialized, registering session listeners");
        VaadinService service = serviceInitEvent.getSource();
        service.addSessionInitListener(this::sessionInit);
        service.addSessionDestroyListener(this::sessionDestroy);
    }

    void sessionInit(SessionInitEvent sessionInitEvent) {
        VaadinSession session = sessionInitEvent.getSession();
        if (LOGGER.isDebugEnabled() && session != null) {
            String sessionId = session.getSession().getId();
            LOGGER.debug("Session initialized: {}", (Object)sessionId);
        }
        int count = this.counter.incrementAndGet();
        LOGGER.debug("Session counter incremented to {}", (Object)count);
    }

    void sessionDestroy(SessionDestroyEvent sessionDestroyEvent) {
        VaadinSession session = sessionDestroyEvent.getSession();
        if (LOGGER.isDebugEnabled() && session != null) {
            String sessionId = session.getSession().getId();
            LOGGER.debug("Session destroyed: {}", (Object)sessionId);
        }
        int count = this.counter.decrementAndGet();
        LOGGER.debug("Session counter decremented to {}", (Object)count);
    }

    @ReadOperation
    public VaadinInfo vaadinInfo() {
        return new VaadinInfo(Version.getFullVersion(), this.counter.get());
    }

    public record VaadinInfo(String version, int sessions) {
    }
}

