/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.controlcenter.starter;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.oauth2.client.oidc.userinfo.OidcUserRequest;
import org.springframework.security.oauth2.client.registration.ClientRegistration;
import org.springframework.security.oauth2.core.OAuth2AccessToken;
import org.springframework.security.oauth2.core.oidc.OidcUserInfo;
import org.springframework.security.oauth2.core.oidc.user.DefaultOidcUser;
import org.springframework.security.oauth2.core.oidc.user.OidcUser;
import org.springframework.security.oauth2.core.oidc.user.OidcUserAuthority;
import org.springframework.security.oauth2.jwt.Jwt;
import org.springframework.security.oauth2.jwt.JwtValidators;
import org.springframework.security.oauth2.jwt.NimbusJwtDecoder;
import org.springframework.util.StringUtils;

class KeycloakUserMapper
implements BiFunction<OidcUserRequest, OidcUserInfo, OidcUser> {
    static final TypeReference<Map<String, List<String>>> LIST_TYPE = new TypeReference<Map<String, List<String>>>(){};
    static final TypeReference<Map<String, Map<String, List<String>>>> MAP_TYPE = new TypeReference<Map<String, Map<String, List<String>>>>(){};
    static final String REALM_ACCESS_CLAIM = "realm_access";
    static final String RESOURCE_ACCESS_CLAIM = "resource_access";
    static final String ROLES_CLAIM = "roles";
    static final String ROLE_PREFIX = "ROLE_";
    static final String SCOPE_PREFIX = "SCOPE_";
    private final ObjectMapper mapper;

    KeycloakUserMapper(ObjectMapper mapper) {
        this.mapper = mapper;
    }

    @Override
    public OidcUser apply(OidcUserRequest userRequest, OidcUserInfo userInfo) {
        String userNameAttributeName;
        Map claim;
        LinkedHashSet<OidcUserAuthority> authorities = new LinkedHashSet<OidcUserAuthority>();
        OAuth2AccessToken accessToken = userRequest.getAccessToken();
        accessToken.getScopes().stream().map(OidcScopeAuthority::new).forEach(authorities::add);
        ClientRegistration clientRegistration = userRequest.getClientRegistration();
        String clientId = clientRegistration.getClientId();
        ClientRegistration.ProviderDetails providerDetails = clientRegistration.getProviderDetails();
        String issuerUri = providerDetails.getIssuerUri();
        String jwkSetUri = providerDetails.getJwkSetUri();
        NimbusJwtDecoder jwtDecoder = NimbusJwtDecoder.withJwkSetUri((String)jwkSetUri).build();
        jwtDecoder.setJwtValidator(JwtValidators.createDefaultWithIssuer((String)issuerUri));
        Jwt jwt = jwtDecoder.decode(accessToken.getTokenValue());
        if (jwt.hasClaim(REALM_ACCESS_CLAIM)) {
            claim = (Map)this.mapper.convertValue((Object)jwt.getClaimAsMap(REALM_ACCESS_CLAIM), LIST_TYPE);
            List roles = claim.getOrDefault(ROLES_CLAIM, List.of());
            roles.stream().map(KeycloakRealmRole::new).forEach(authorities::add);
        }
        if (jwt.hasClaim(RESOURCE_ACCESS_CLAIM)) {
            claim = (Map)this.mapper.convertValue((Object)jwt.getClaimAsMap(RESOURCE_ACCESS_CLAIM), MAP_TYPE);
            Map resources = claim.getOrDefault(clientId, Map.of());
            List roles = resources.getOrDefault(ROLES_CLAIM, List.of());
            roles.stream().map(role -> new KeycloakClientRole(clientId, (String)role)).forEach(authorities::add);
        }
        if (StringUtils.hasText((String)(userNameAttributeName = providerDetails.getUserInfoEndpoint().getUserNameAttributeName()))) {
            authorities.add(new OidcUserAuthority(userRequest.getIdToken(), userInfo, userNameAttributeName));
            return new DefaultOidcUser(authorities, userRequest.getIdToken(), userNameAttributeName);
        }
        authorities.add(new OidcUserAuthority(userRequest.getIdToken(), userInfo));
        return new DefaultOidcUser(authorities, userRequest.getIdToken(), userInfo);
    }

    record KeycloakClientRole(String client, String role) implements GrantedAuthority
    {
        public String getAuthority() {
            return KeycloakUserMapper.ROLE_PREFIX + this.role;
        }
    }

    record KeycloakRealmRole(String role) implements GrantedAuthority
    {
        public String getAuthority() {
            return KeycloakUserMapper.ROLE_PREFIX + this.role;
        }
    }

    record OidcScopeAuthority(String scope) implements GrantedAuthority
    {
        public String getAuthority() {
            return KeycloakUserMapper.SCOPE_PREFIX + this.scope;
        }
    }
}

