/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.controlcenter.starter.idm;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.vaadin.controlcenter.starter.idm.IdentityManagementProperties;
import com.vaadin.controlcenter.starter.idm.RefreshTokenFilter;
import com.vaadin.flow.spring.security.AuthenticationContext;
import com.vaadin.flow.spring.security.RequestUtil;
import com.vaadin.flow.spring.security.UidlRedirectStrategy;
import com.vaadin.flow.spring.security.VaadinWebSecurity;
import jakarta.servlet.Filter;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnCloudPlatform;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.cloud.CloudPlatform;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.context.annotation.Bean;
import org.springframework.security.config.annotation.web.builders.HttpSecurity;
import org.springframework.security.config.annotation.web.configuration.EnableWebSecurity;
import org.springframework.security.config.annotation.web.configuration.WebSecurityCustomizer;
import org.springframework.security.config.annotation.web.configurers.AuthorizeHttpRequestsConfigurer;
import org.springframework.security.config.annotation.web.configurers.CsrfConfigurer;
import org.springframework.security.config.annotation.web.configurers.LogoutConfigurer;
import org.springframework.security.config.annotation.web.configurers.oauth2.client.OAuth2LoginConfigurer;
import org.springframework.security.config.annotation.web.configurers.oauth2.client.OidcLogoutConfigurer;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.authority.SimpleGrantedAuthority;
import org.springframework.security.oauth2.client.OAuth2AuthorizedClientService;
import org.springframework.security.oauth2.client.oidc.userinfo.OidcUserRequest;
import org.springframework.security.oauth2.client.oidc.userinfo.OidcUserService;
import org.springframework.security.oauth2.client.oidc.web.logout.OidcClientInitiatedLogoutSuccessHandler;
import org.springframework.security.oauth2.client.registration.ClientRegistration;
import org.springframework.security.oauth2.client.registration.ClientRegistrationRepository;
import org.springframework.security.oauth2.core.OAuth2AccessToken;
import org.springframework.security.oauth2.core.oidc.OidcUserInfo;
import org.springframework.security.oauth2.core.oidc.user.DefaultOidcUser;
import org.springframework.security.oauth2.core.oidc.user.OidcUser;
import org.springframework.security.oauth2.core.oidc.user.OidcUserAuthority;
import org.springframework.security.oauth2.jwt.Jwt;
import org.springframework.security.oauth2.jwt.JwtValidators;
import org.springframework.security.oauth2.jwt.NimbusJwtDecoder;
import org.springframework.security.web.RedirectStrategy;
import org.springframework.security.web.SecurityFilterChain;
import org.springframework.security.web.authentication.AnonymousAuthenticationFilter;
import org.springframework.security.web.authentication.logout.LogoutSuccessHandler;
import org.springframework.security.web.util.matcher.RequestMatcher;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

@AutoConfiguration
@EnableWebSecurity
@ConditionalOnCloudPlatform(value=CloudPlatform.KUBERNETES)
@ConditionalOnMissingBean(value={IdentityManagementConfiguration.class})
@EnableConfigurationProperties(value={IdentityManagementProperties.class})
public class IdentityManagementConfiguration
extends VaadinWebSecurity {
    private static final String BACK_CHANNEL_LOGOUT_URI = "{baseScheme}://{baseHost}{basePort}/logout";
    private static final String REALM_ACCESS_CLAIM = "realm_access";
    private static final String RESOURCE_ACCESS_CLAIM = "resource_access";
    private static final String ROLES_CLAIM = "roles";
    private static final String ROLE_PREFIX = "ROLE_";
    private static final String SCOPE_PREFIX = "SCOPE_";
    private static final ObjectMapper MAPPER = new ObjectMapper();
    private IdentityManagementProperties properties;
    private ClientRegistrationRepository clientRegistrationRepository;
    private OAuth2AuthorizedClientService oAuth2AuthorizedClientService;
    private RequestUtil requestUtil;

    @Autowired
    void setProperties(IdentityManagementProperties properties) {
        this.properties = properties;
    }

    @Autowired
    void setClientRegistrationRepository(ClientRegistrationRepository clientRegistrationRepository) {
        this.clientRegistrationRepository = clientRegistrationRepository;
    }

    @Autowired
    void setOAuth2AuthorizedClientService(OAuth2AuthorizedClientService oAuth2AuthorizedClientService) {
        this.oAuth2AuthorizedClientService = oAuth2AuthorizedClientService;
    }

    @Autowired
    void setRequestUtil(RequestUtil requestUtil) {
        this.requestUtil = requestUtil;
    }

    @Bean(name={"VaadinSecurityFilterChainBean"})
    @ConditionalOnMissingBean(name={"VaadinSecurityFilterChainBean"})
    @RefreshScope
    public SecurityFilterChain filterChain(HttpSecurity http) throws Exception {
        return super.filterChain(http);
    }

    @Bean(name={"VaadinWebSecurityCustomizerBean"})
    @ConditionalOnMissingBean(name={"VaadinWebSecurityCustomizerBean"})
    @RefreshScope
    public WebSecurityCustomizer webSecurityCustomizer() {
        return super.webSecurityCustomizer();
    }

    @Bean(name={"VaadinAuthenticationContext"})
    @ConditionalOnMissingBean(name={"VaadinAuthenticationContext"})
    @RefreshScope
    public AuthenticationContext getAuthenticationContext() {
        return super.getAuthenticationContext();
    }

    @Bean
    @ConditionalOnMissingBean
    OidcUserService oidcUserService() {
        OidcUserService oidcUserService = new OidcUserService();
        oidcUserService.setOidcUserMapper(this::keycloakUserMapper);
        return oidcUserService;
    }

    protected void configure(HttpSecurity http) throws Exception {
        if (this.properties.isEnabled()) {
            this.withIdentityManagementEnabled(http);
            super.configure(http);
        } else {
            this.withIdentityManagementDisabled(http);
        }
    }

    protected void withIdentityManagementEnabled(HttpSecurity http) throws Exception {
        http.addFilterBefore((Filter)new RefreshTokenFilter(this.oAuth2AuthorizedClientService), AnonymousAuthenticationFilter.class);
        http.authorizeHttpRequests(this::requestWhitelist);
        http.oauth2Login(this::configureOidcLogin);
        this.setOAuth2LoginPage(http, this.properties.getLoginRoute());
        http.oidcLogout(this::configureOidcLogout);
        http.logout(this::configureLogout);
    }

    protected void withIdentityManagementDisabled(HttpSecurity http) throws Exception {
        http.csrf(this::ignoreInternalRequests);
        http.authorizeHttpRequests(this::authorizeAnyRequest);
    }

    protected void requestWhitelist(AuthorizeHttpRequestsConfigurer.AuthorizationManagerRequestMatcherRegistry urlRegistry) {
        ((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)urlRegistry.requestMatchers(new String[]{"/actuator/**"})).permitAll();
    }

    protected void ignoreInternalRequests(CsrfConfigurer<HttpSecurity> csrf) {
        RequestMatcher[] requestMatcherArray = new RequestMatcher[1];
        requestMatcherArray[0] = arg_0 -> ((RequestUtil)this.requestUtil).isFrameworkInternalRequest(arg_0);
        csrf.ignoringRequestMatchers(requestMatcherArray);
    }

    private void configureOidcLogin(OAuth2LoginConfigurer<HttpSecurity> login) {
        login.defaultSuccessUrl(this.properties.getLoginSuccessRoute());
    }

    private void configureOidcLogout(OidcLogoutConfigurer<HttpSecurity> logout) {
        logout.backChannel(backChannel -> backChannel.logoutUri(BACK_CHANNEL_LOGOUT_URI));
    }

    private void configureLogout(LogoutConfigurer<HttpSecurity> logout) {
        OidcClientInitiatedLogoutSuccessHandler logoutSuccessHandler = new OidcClientInitiatedLogoutSuccessHandler(this.clientRegistrationRepository);
        String logoutSuccessRoute = this.properties.getLogoutSuccessRoute();
        logoutSuccessHandler.setPostLogoutRedirectUri(logoutSuccessRoute);
        logoutSuccessHandler.setRedirectStrategy((RedirectStrategy)new UidlRedirectStrategy());
        logout.logoutSuccessHandler((LogoutSuccessHandler)logoutSuccessHandler);
    }

    private void authorizeAnyRequest(AuthorizeHttpRequestsConfigurer.AuthorizationManagerRequestMatcherRegistry urlRegistry) {
        ((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)urlRegistry.anyRequest()).permitAll();
    }

    private OidcUser keycloakUserMapper(OidcUserRequest userRequest, OidcUserInfo userInfo) {
        Collection<? extends GrantedAuthority> authorities = IdentityManagementConfiguration.mapAuthorities(userRequest, userInfo);
        ClientRegistration.ProviderDetails providerDetails = userRequest.getClientRegistration().getProviderDetails();
        String userNameAttributeName = providerDetails.getUserInfoEndpoint().getUserNameAttributeName();
        if (StringUtils.hasText((String)userNameAttributeName)) {
            return new DefaultOidcUser(authorities, userRequest.getIdToken(), userInfo, userNameAttributeName);
        }
        return new DefaultOidcUser(authorities, userRequest.getIdToken(), userInfo);
    }

    public static Collection<? extends GrantedAuthority> mapAuthorities(OidcUserRequest userRequest, OidcUserInfo userInfo) {
        LinkedHashSet<Object> authorities = new LinkedHashSet<Object>();
        authorities.add(new OidcUserAuthority(userRequest.getIdToken(), userInfo));
        OAuth2AccessToken accessToken = userRequest.getAccessToken();
        for (String scope : accessToken.getScopes()) {
            authorities.add(new SimpleGrantedAuthority(SCOPE_PREFIX + scope));
        }
        ClientRegistration clientRegistration = userRequest.getClientRegistration();
        String issuer = clientRegistration.getProviderDetails().getIssuerUri();
        NimbusJwtDecoder jwtDecoder = NimbusJwtDecoder.withJwkSetUri((String)clientRegistration.getProviderDetails().getJwkSetUri()).build();
        jwtDecoder.setJwtValidator(JwtValidators.createDefaultWithIssuer((String)issuer));
        Jwt jwt = jwtDecoder.decode(accessToken.getTokenValue());
        if (jwt.hasClaim(REALM_ACCESS_CLAIM)) {
            Map realmAccessClaim = (Map)MAPPER.convertValue((Object)jwt.getClaimAsMap(REALM_ACCESS_CLAIM), (TypeReference)new TypeReference<Map<String, List<String>>>(){});
            List roles = realmAccessClaim.getOrDefault(ROLES_CLAIM, List.of());
            roles.stream().map(String.class::cast).map(KeycloakRealmRole::new).forEach(authorities::add);
        }
        if (jwt.hasClaim(RESOURCE_ACCESS_CLAIM)) {
            Map resourceAccessClaim = (Map)MAPPER.convertValue((Object)jwt.getClaimAsMap(RESOURCE_ACCESS_CLAIM), (TypeReference)new TypeReference<Map<String, Map<String, List<String>>>>(){});
            String clientId = clientRegistration.getClientId();
            Map clientResources = resourceAccessClaim.getOrDefault(clientId, Map.of());
            List roles = clientResources.getOrDefault(ROLES_CLAIM, List.of());
            roles.stream().map(String.class::cast).map(role -> new KeycloakClientRole(clientId, (String)role)).forEach(authorities::add);
        }
        return Set.copyOf(authorities);
    }

    static class KeycloakClientRole
    implements GrantedAuthority {
        private final String client;
        private final String role;

        public KeycloakClientRole(String client, String role) {
            Assert.hasText((String)client, (String)"Client must not be empty");
            Assert.hasText((String)role, (String)"Role must not be empty");
            this.client = client;
            this.role = role;
        }

        public String getClient() {
            return this.client;
        }

        public String getRole() {
            return this.role;
        }

        public String getAuthority() {
            return IdentityManagementConfiguration.ROLE_PREFIX + this.role;
        }

        public int hashCode() {
            return Objects.hash(this.client, this.role);
        }

        public boolean equals(Object obj) {
            if (obj instanceof KeycloakClientRole) {
                KeycloakClientRole kcr = (KeycloakClientRole)obj;
                return Objects.equals(this.client, kcr.client) && Objects.equals(this.role, kcr.role);
            }
            return false;
        }
    }

    static class KeycloakRealmRole
    implements GrantedAuthority {
        private final String role;

        public KeycloakRealmRole(String role) {
            Assert.hasText((String)role, (String)"Role must not be empty");
            this.role = role;
        }

        public String getRole() {
            return this.role;
        }

        public String getAuthority() {
            return IdentityManagementConfiguration.ROLE_PREFIX + this.role;
        }

        public int hashCode() {
            return Objects.hash(this.role);
        }

        public boolean equals(Object other) {
            if (other instanceof KeycloakRealmRole) {
                KeycloakRealmRole krr = (KeycloakRealmRole)other;
                return Objects.equals(this.role, krr.role);
            }
            return false;
        }
    }
}

