/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.controlcenter.starter.i18n;

import jakarta.servlet.Filter;
import jakarta.servlet.FilterChain;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.Cookie;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;

public class I18NPreviewFilter
implements Filter {
    private static final String I18N_PREVIEW_PARAM = "i18n-preview";
    private static final String I18N_PREVIEW_COOKIE = "i18n-preview";

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        if (request instanceof HttpServletRequest) {
            HttpServletRequest httpRequest = (HttpServletRequest)request;
            if (response instanceof HttpServletResponse) {
                HttpServletResponse httpResponse = (HttpServletResponse)response;
                String previewParam = httpRequest.getParameter("i18n-preview");
                if ("enable".equals(previewParam)) {
                    Cookie cookie = new Cookie("i18n-preview", "true");
                    cookie.setPath("/");
                    cookie.setHttpOnly(true);
                    cookie.setSecure(true);
                    httpResponse.addCookie(cookie);
                } else if ("disable".equals(previewParam)) {
                    Cookie cookie = new Cookie("i18n-preview", "false");
                    cookie.setPath("/");
                    cookie.setMaxAge(0);
                    cookie.setHttpOnly(true);
                    cookie.setSecure(true);
                    httpResponse.addCookie(cookie);
                }
            }
        }
        chain.doFilter(request, response);
    }
}

