/*
 * Copyright (C) 2025 Vaadin Ltd
 *
 * This program is available under Vaadin Commercial License and Service Terms.
 *
 * See <https://vaadin.com/commercial-license-and-service-terms> for the full license.
 */
package com.vaadin.controlcenter.starter.usage;

import java.io.IOException;

import com.vaadin.flow.internal.UsageStatistics;
import com.vaadin.flow.server.ServiceInitEvent;
import com.vaadin.flow.server.VaadinServiceInitListener;

import static org.springframework.core.io.support.PropertiesLoaderUtils.loadAllProperties;

/**
 * Service initialization listener for usage tracking.
 */
class UsageServiceInitListener implements VaadinServiceInitListener {

    static final String PROPERTIES_RESOURCE = "control-center.properties";

    static final String VERSION_PROPERTY = "control-center.version";

    static final String PRODUCT_NAME = "control-center";

    @Override
    public void serviceInit(ServiceInitEvent event) {
        try {
            final var properties = loadAllProperties(PROPERTIES_RESOURCE);
            final var version = properties.getProperty(VERSION_PROPERTY);
            UsageStatistics.markAsUsed(PRODUCT_NAME, version);
        } catch (IOException e) {
            throw new ExceptionInInitializerError(e);
        }
    }
}
