/*-
 * Copyright (C) 2024 Vaadin Ltd
 *
 * This program is available under Vaadin Commercial License and Service Terms.
 *
 * See <https://vaadin.com/commercial-license-and-service-terms> for the full license.
-*/
package com.vaadin.controlcenter.starter.idm;

import java.util.Objects;

import org.springframework.security.oauth2.client.registration.ClientRegistration;
import org.springframework.security.oauth2.client.registration.ClientRegistrationRepository;

/**
 * A delegating client registration repository that delegates to another
 * repository.
 * <p>
 * This could be used to wrap a repository which implementation is final and
 * therefore cannot be annotated with {@code @RefreshScope}.
 */
class DelegatingClientRegistrationRepository
        implements ClientRegistrationRepository {

    private final ClientRegistrationRepository delegate;

    /**
     * Creates a new instance with the given delegate.
     *
     * @param delegate
     *            the delegate to use, not {@code null}
     */
    DelegatingClientRegistrationRepository(
            ClientRegistrationRepository delegate) {
        this.delegate = Objects.requireNonNull(delegate);
    }

    @Override
    public ClientRegistration findByRegistrationId(String registrationId) {
        return delegate.findByRegistrationId(registrationId);
    }
}
