/*-
 * Copyright (C) 2024 Vaadin Ltd
 *
 * This program is available under Vaadin Commercial License and Service Terms.
 *
 * See <https://vaadin.com/commercial-license-and-service-terms> for the full license.
-*/
package com.vaadin.controlcenter.starter.actuate.endpoint;

import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnCloudPlatform;
import org.springframework.boot.cloud.CloudPlatform;
import org.springframework.context.annotation.Bean;

import com.vaadin.controlcenter.starter.actuate.VaadinActuatorConfiguration;
import com.vaadin.controlcenter.starter.i18n.ControlCenterI18NProperties;
import com.vaadin.controlcenter.starter.idm.IdentityManagementProperties;
import com.vaadin.flow.server.VaadinServiceInitListener;

/**
 * Configuration for the Vaadin's actuator endpoint.
 *
 * @deprecated replaced by {@link VaadinActuatorConfiguration}
 */
@Deprecated(since = "1.1.0", forRemoval = true)
@AutoConfiguration
@ConditionalOnCloudPlatform(CloudPlatform.KUBERNETES)
public class VaadinActuatorEndpointConfiguration {

    /**
     * Creates a bean for the Vaadin's actuator endpoint.
     *
     * @return the Vaadin's actuator endpoint bean
     */
    @Bean
    VaadinActuatorEndpoint vaadinActuatorEndpoint(
            IdentityManagementProperties identityManagementProperties,
            ControlCenterI18NProperties localizationProperties) {
        return new VaadinActuatorEndpoint(identityManagementProperties,
                localizationProperties);
    }

    /**
     * Returns a {@code VaadinServiceInitListener} that registers the Vaadin
     * service with the actuator endpoint.
     *
     * @param vaadinActuatorEndpoint
     *            the Vaadin actuator endpoint
     * @return the Vaadin service init listener
     */
    @Bean
    VaadinServiceInitListener vaadinServiceInitListener(
            VaadinActuatorEndpoint vaadinActuatorEndpoint) {
        return event -> vaadinActuatorEndpoint.register(event.getSource());
    }
}
