/*-
 * Copyright (C) 2024 Vaadin Ltd
 *
 * This program is available under Vaadin Commercial License and Service Terms.
 *
 * See <https://vaadin.com/commercial-license-and-service-terms> for the full license.
-*/
package com.vaadin.controlcenter.starter.actuate.endpoint;

import java.util.Map;

import org.springframework.boot.actuate.endpoint.OperationResponseBody;
import org.springframework.boot.actuate.endpoint.annotation.Endpoint;
import org.springframework.boot.actuate.endpoint.annotation.ReadOperation;

import com.vaadin.controlcenter.starter.actuate.VaadinInfoContributor;
import com.vaadin.controlcenter.starter.i18n.ControlCenterI18NProperties;
import com.vaadin.controlcenter.starter.idm.IdentityManagementProperties;
import com.vaadin.flow.server.Constants;
import com.vaadin.flow.server.VaadinService;
import com.vaadin.flow.server.Version;

/**
 * Actuator endpoint to expose Vaadin related information like Flow version,
 * license, etc.
 *
 * @deprecated replaced by {@link VaadinInfoContributor}
 */
@Deprecated(since = "1.1.0", forRemoval = true)
@Endpoint(id = VaadinActuatorEndpoint.ENDPOINT_NAME)
public class VaadinActuatorEndpoint {

    /**
     * The endpoint name.
     */
    public static final String ENDPOINT_NAME = "vaadin";

    private final IdentityManagementProperties idmProperties;

    private final ControlCenterI18NProperties i18nProperties;

    private VaadinService vaadinService = null;

    /**
     * Creates a new instance of the endpoint.
     *
     * @param idmProperties
     *            the Identity Management properties
     * @param i18nProperties
     *            the Localization properties
     */
    public VaadinActuatorEndpoint(IdentityManagementProperties idmProperties,
            ControlCenterI18NProperties i18nProperties) {
        this.idmProperties = idmProperties;
        this.i18nProperties = i18nProperties;
    }

    /**
     * Registers the Vaadin service.
     *
     * @param vaadinService
     *            the Vaadin service
     */
    public void register(VaadinService vaadinService) {
        this.vaadinService = vaadinService;
    }

    /**
     * Read operation that returns information about Vaadin.
     *
     * @return the Vaadin information
     */
    @ReadOperation
    public VaadinInfo vaadinInfo() {
        var flowInfo = getFlowInfo();
        var premium = getPremiumFeaturesEnabled();
        var features = getFeatures();
        return new VaadinInfo(flowInfo, premium, features);
    }

    private FlowInfo getFlowInfo() {
        var version = Version.getFullVersion();
        return new FlowInfo(version);
    }

    private boolean getPremiumFeaturesEnabled() {
        if (vaadinService != null) {
            return vaadinService.getDeploymentConfiguration()
                    .getBooleanProperty(Constants.PREMIUM_FEATURES, false);
        }
        return false;
    }

    private Map<String, Boolean> getFeatures() {
        return Map.of("idm", idmProperties.isEnabled(), "i18n",
                i18nProperties.isEnabled());
    }

    /**
     * Object to store information about Vaadin.
     *
     * @param flow
     *            the Flow information
     * @param premium
     *            whether premium features are enabled
     * @param features
     *            the enabled state of Control Center features
     * @deprecated replaced by {@link VaadinInfoContributor}
     */
    @Deprecated(since = "1.1.0", forRemoval = true)
    public record VaadinInfo(FlowInfo flow, boolean premium,
            Map<String, Boolean> features) implements OperationResponseBody {
    }

    /**
     * Object to store information about Flow.
     *
     * @param version
     *            the Flow version
     * @deprecated replaced by {@link VaadinInfoContributor}
     */
    @Deprecated(since = "1.1.0", forRemoval = true)
    public record FlowInfo(String version) implements OperationResponseBody {
    }
}
