/*-
 * Copyright (C) 2025 Vaadin Ltd
 *
 * This program is available under Vaadin Commercial License and Service Terms.
 *
 * See <https://vaadin.com/commercial-license-and-service-terms> for the full license.
-*/
package com.vaadin.controlcenter.starter.actuate;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

import org.springframework.boot.actuate.info.Info;
import org.springframework.boot.actuate.info.InfoContributor;
import org.springframework.context.ApplicationContext;

import com.vaadin.flow.server.Version;

/**
 * Info contributor for Vaadin apps.
 */
public class VaadinInfoContributor implements InfoContributor {

    public static final String VAADIN_KEY = "vaadin";
    public static final String FLOW_VERSION_KEY = "flowVersion";
    public static final String APPLICATION_CONTEXT_KEY = "applicationContext";
    public static final String CONTROL_CENTER_VERSION_KEY = "controlCenterVersion";

    private final ApplicationContext applicationContext;

    /**
     * Creates a new instance of the info contributor.
     *
     * @param applicationContext
     *            the Spring application context
     */
    VaadinInfoContributor(ApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
    }

    @Override
    public void contribute(Info.Builder builder) {
        Map<String, String> infoMap = new HashMap<>();
        infoMap.put(FLOW_VERSION_KEY, Version.getFullVersion());
        infoMap.put(APPLICATION_CONTEXT_KEY,
                Objects.requireNonNull(applicationContext.getId()));
        var controlCenterVersion = getImplementationVersion();
        if (controlCenterVersion != null) {
            infoMap.put(CONTROL_CENTER_VERSION_KEY, controlCenterVersion);
        }

        builder.withDetail(VAADIN_KEY, infoMap);
    }

    protected String getImplementationVersion() {
        return this.getClass().getPackage().getImplementationVersion();
    }
}
