/*
 * Copyright (C) 2024 Vaadin Ltd
 *
 * This program is available under Vaadin Commercial License and Service Terms.
 *
 * See <https://vaadin.com/commercial-license-and-service-terms> for the full license.
 */
package com.vaadin.controlcenter.starter.actuate;

import org.springframework.boot.actuate.autoconfigure.info.ConditionalOnEnabledInfoContributor;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnCloudPlatform;
import org.springframework.boot.cloud.CloudPlatform;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;

/**
 * Configuration for Vaadin contributions to actuator endpoints.
 */
@AutoConfiguration
public class VaadinActuatorConfiguration {

    @Bean
    @ConditionalOnEnabledInfoContributor("vaadin")
    @ConditionalOnCloudPlatform(CloudPlatform.KUBERNETES)
    VaadinInfoContributor vaadinInfoContributor(ApplicationContext context) {
        return new VaadinInfoContributor(context);
    }
}
