/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.controlcenter.starter.idm;

import com.vaadin.controlcenter.starter.idm.DelegatingClientRegistrationRepository;
import com.vaadin.controlcenter.starter.idm.IdentityManagementProperties;
import java.util.HashMap;
import java.util.Map;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnCloudPlatform;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.cloud.CloudPlatform;
import org.springframework.boot.web.client.RestTemplateBuilder;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.context.annotation.Bean;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.RequestEntity;
import org.springframework.security.oauth2.client.registration.ClientRegistration;
import org.springframework.security.oauth2.client.registration.ClientRegistrationRepository;
import org.springframework.security.oauth2.client.registration.ClientRegistrations;
import org.springframework.security.oauth2.client.registration.InMemoryClientRegistrationRepository;
import org.springframework.web.client.RestTemplate;

@AutoConfiguration
class ClientRegistrationRepositoryConfiguration {
    private static final ParameterizedTypeReference<Map<String, Object>> MAP_TYPE_REFERENCE = new ParameterizedTypeReference<Map<String, Object>>(){};
    private final RestTemplate rest;

    ClientRegistrationRepositoryConfiguration(RestTemplateBuilder builder) {
        this.rest = builder.build();
    }

    @Bean
    @RefreshScope
    @ConditionalOnMissingBean
    @ConditionalOnCloudPlatform(value=CloudPlatform.KUBERNETES)
    ClientRegistrationRepository clientRegistrationRepository(IdentityManagementProperties properties) {
        HashMap<String, ClientRegistration> registrations = new HashMap<String, ClientRegistration>();
        String issuerBackendUri = properties.getIssuerBackendUri();
        if (issuerBackendUri != null) {
            String issuerFrontendUri = properties.getIssuerFrontendUri();
            String clientId = properties.getClientId();
            String clientSecret = properties.getClientSecret();
            String clientRegistrationId = properties.getClientRegistrationId();
            Map<String, Object> configuration = this.getConfiguration(issuerBackendUri);
            if (configuration == null) {
                String message = "Failed to retrieve configuration from %s";
                throw new IllegalStateException(message.formatted(issuerBackendUri));
            }
            Object metadataIssuer = configuration.get("issuer");
            if (!issuerFrontendUri.equals(metadataIssuer)) {
                String message = "The Issuer %s provided by the configuration did not match the expected issuer %s";
                throw new IllegalStateException(message.formatted(metadataIssuer, issuerFrontendUri));
            }
            ClientRegistration registration = ClientRegistrations.fromOidcConfiguration(configuration).registrationId(clientRegistrationId).clientId(clientId).clientSecret(clientSecret).scope(new String[]{"openid"}).build();
            registrations.put(clientRegistrationId, registration);
        }
        InMemoryClientRegistrationRepository delegate = new InMemoryClientRegistrationRepository(registrations);
        return new DelegatingClientRegistrationRepository((ClientRegistrationRepository)delegate);
    }

    private Map<String, Object> getConfiguration(String issuerUri) {
        String metadataEndpoint = issuerUri + "/.well-known/openid-configuration";
        RequestEntity request = RequestEntity.get((String)metadataEndpoint, (Object[])new Object[0]).build();
        return (Map)this.rest.exchange(request, MAP_TYPE_REFERENCE).getBody();
    }
}

